/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.compat.jei.RecipeTypes;
import novamachina.exnihilosequentia.common.compat.jei.compost.CompostRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.crook.CrookRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.crucible.CrucibleRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.crucible.JEICrucibleRecipe;
import novamachina.exnihilosequentia.common.compat.jei.fluiditem.FluidBlockRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.fluidontop.FluidOnTopRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.fluidtransform.FluidTransformCategory;
import novamachina.exnihilosequentia.common.compat.jei.hammer.HammerRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.heat.HeatRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.sieve.DrySieveRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.sieve.JEISieveRecipe;
import novamachina.exnihilosequentia.common.compat.jei.sieve.WetSieveRecipeCategory;
import novamachina.exnihilosequentia.common.crafting.compost.CompostRecipe;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.common.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.common.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.common.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.common.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.CrookBaseItem;
import novamachina.exnihilosequentia.common.item.HammerBaseItem;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.ExNihiloConstants;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private static final ResourceLocation CRUCIBLES = new ResourceLocation("exnihilosequentia", "crucibles");
    @Nonnull
    private static final ResourceLocation FIRED_CRUCIBLES = new ResourceLocation("exnihilosequentia", ExNihiloConstants.Blocks.FIRED_CRUCIBLE);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "exnihilosequentia");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CrookRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DrySieveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WetSieveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidTransformCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidBlockRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "crucibles")});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, ExNihiloConstants.Blocks.FIRED_CRUCIBLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_WOOD.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_STONE.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_ANDESITE.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_GRANITE.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_DIORITE.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_GOLD.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_IRON.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_DIAMOND.get()), registration);
        this.registerCookCatalyst((CrookBaseItem)((Object)ExNihiloItems.CROOK_BONE.get()), registration);
        this.registerHammerCatalyst((HammerBaseItem)((Object)ExNihiloItems.HAMMER_DIAMOND.get()), registration);
        this.registerHammerCatalyst((HammerBaseItem)((Object)ExNihiloItems.HAMMER_GOLD.get()), registration);
        this.registerHammerCatalyst((HammerBaseItem)((Object)ExNihiloItems.HAMMER_IRON.get()), registration);
        this.registerHammerCatalyst((HammerBaseItem)((Object)ExNihiloItems.HAMMER_NETHERITE.get()), registration);
        this.registerHammerCatalyst((HammerBaseItem)((Object)ExNihiloItems.HAMMER_STONE.get()), registration);
        this.registerHammerCatalyst((HammerBaseItem)((Object)ExNihiloItems.HAMMER_WOOD.get()), registration);
        this.registerCrucibles(registration);
        this.registerBarrels(registration);
        this.registerSieves(registration);
    }

    private void registerCookCatalyst(CrookBaseItem crook, @Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)crook), new RecipeType[]{RecipeTypes.CROOK});
    }

    private void registerHammerCatalyst(HammerBaseItem hammer, @Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)hammer), new RecipeType[]{RecipeTypes.HAMMER});
    }

    private void registerCrucibles(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_ACACIA.get()), new RecipeType[]{RecipeTypes.CRUCIBLE, RecipeTypes.HEAT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_BIRCH.get()), new RecipeType[]{RecipeTypes.CRUCIBLE, RecipeTypes.HEAT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_DARK_OAK.get()), new RecipeType[]{RecipeTypes.CRUCIBLE, RecipeTypes.HEAT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_JUNGLE.get()), new RecipeType[]{RecipeTypes.CRUCIBLE, RecipeTypes.HEAT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_OAK.get()), new RecipeType[]{RecipeTypes.CRUCIBLE, RecipeTypes.HEAT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_SPRUCE.get()), new RecipeType[]{RecipeTypes.CRUCIBLE, RecipeTypes.HEAT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_FIRED.get()), new RecipeType[]{RecipeTypes.FIRED_CRUCIBLE, RecipeTypes.CRUCIBLE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_CRIMSON.get()), new RecipeType[]{RecipeTypes.FIRED_CRUCIBLE, RecipeTypes.CRUCIBLE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_WARPED.get()), new RecipeType[]{RecipeTypes.FIRED_CRUCIBLE, RecipeTypes.CRUCIBLE});
    }

    private void registerBarrels(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_ACACIA.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_BIRCH.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_DARK_OAK.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_JUNGLE.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_OAK.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_SPRUCE.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_STONE.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_CRIMSON.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.BARREL_WARPED.get()), new RecipeType[]{RecipeTypes.FLUID_ON_TOP, RecipeTypes.FLUID_TRANSFORM, RecipeTypes.FLUID_ITEM, RecipeTypes.COMPOST});
    }

    private void registerSieves(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_ACACIA.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_BIRCH.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_DARK_OAK.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_JUNGLE.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_OAK.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_SPRUCE.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_CRIMSON.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_WARPED.get()), new RecipeType[]{RecipeTypes.DRY_SIEVE, RecipeTypes.WET_SIEVE});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        this.registerCrook(registration);
        this.registerSieve(registration);
        this.registerHammer(registration);
        this.registerFluidOnTop(registration);
        this.registerFluidTransform(registration);
        this.registerFluidBlock(registration);
        this.registerCompost(registration);
        this.registerFiredCrucible(registration);
        this.registerWoodCrucible(registration);
        this.registerHeat(registration);
    }

    private void registerCompost(@Nonnull IRecipeRegistration registration) {
        List<CompostRecipe> recipes = ExNihiloRegistries.COMPOST_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.COMPOST, recipes);
        logger.info("Compost Recipes Loaded: " + recipes.size());
    }

    private void registerCrook(@Nonnull IRecipeRegistration registration) {
        List<CrookRecipe> crookRecipes = ExNihiloRegistries.CROOK_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.CROOK, crookRecipes);
        logger.info("Crook Recipes Loaded: " + crookRecipes.size());
    }

    private void registerFiredCrucible(@Nonnull IRecipeRegistration registration) {
        List<JEICrucibleRecipe> recipes = ExNihiloRegistries.CRUCIBLE_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.FIRED_CRUCIBLE, recipes);
        logger.info("Fired Crucible Recipes Loaded: " + recipes.size());
    }

    private void registerFluidBlock(@Nonnull IRecipeRegistration registration) {
        List<FluidItemRecipe> recipes = ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.FLUID_ITEM, recipes);
        logger.info("Fluid Item Recipes Loaded: " + recipes.size());
    }

    private void registerFluidOnTop(@Nonnull IRecipeRegistration registration) {
        List<FluidOnTopRecipe> recipes = ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.FLUID_ON_TOP, recipes);
        logger.info("Fluid On Top Recipes Loaded: " + recipes.size());
    }

    private void registerFluidTransform(@Nonnull IRecipeRegistration registration) {
        List<FluidTransformRecipe> recipes = ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.FLUID_TRANSFORM, recipes);
        logger.info("Fluid Transform Recipes Loaded: " + recipes.size());
    }

    private void registerHammer(@Nonnull IRecipeRegistration registration) {
        List<HammerRecipe> recipes = ExNihiloRegistries.HAMMER_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.HAMMER, recipes);
        logger.info("Hammer Recipes Loaded: " + recipes.size());
    }

    private void registerHeat(@Nonnull IRecipeRegistration registration) {
        List<HeatRecipe> recipes = ExNihiloRegistries.HEAT_REGISTRY.getRecipeList();
        registration.addRecipes(RecipeTypes.HEAT, recipes);
        logger.info("Heat Recipes Loaded: " + recipes.size());
    }

    private void registerSieve(@Nonnull IRecipeRegistration registration) {
        List<JEISieveRecipe> drySieveRecipes = ExNihiloRegistries.SIEVE_REGISTRY.getDryRecipeList();
        List<JEISieveRecipe> wetSieveRecipes = ExNihiloRegistries.SIEVE_REGISTRY.getWetRecipeList();
        registration.addRecipes(RecipeTypes.DRY_SIEVE, drySieveRecipes);
        registration.addRecipes(RecipeTypes.WET_SIEVE, wetSieveRecipes);
        logger.info("Sieve Recipes Loaded: " + (drySieveRecipes.size() + wetSieveRecipes.size()));
    }

    private void registerWoodCrucible(@Nonnull IRecipeRegistration registration) {
        List recipes = ExNihiloRegistries.CRUCIBLE_REGISTRY.getRecipeList().stream().filter(recipe -> recipe.getCrucibleType() == CrucibleTypeEnum.WOOD).collect(Collectors.toList());
        registration.addRecipes(RecipeTypes.CRUCIBLE, recipes);
        logger.info("Wooden Crucible Recipes Loaded: " + recipes.size());
    }
}

